package com.example.roomtest

import androidx.lifecycle.*
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.launch


class DeptViewModel(private val dao: DeptDAO) : ViewModel() {
    val depts: Flow<List<Dept>> = dao.getDeptNames()
    val allDepts: LiveData<List<Dept>> = this.depts.asLiveData()
    fun insert(dept: Dept) = viewModelScope.launch {
        dao.insert(dept)
    }
}

class DeptViewModelFactory(private val dao: DeptDAO) :
    ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(DeptViewModel::class.java)) {
            @Suppress("UNCHECKED_CAST")
            return DeptViewModel(dao) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}