package com.example.roomtest

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.ListAdapter
import androidx.recyclerview.widget.RecyclerView

class DeptListAdapter : ListAdapter<Dept, DeptListAdapter.
DeptViewHolder>(DeptsComparator()) {

    override fun onCreateViewHolder(parent: ViewGroup,
                                    viewType: Int): DeptViewHolder {
        return DeptViewHolder.create(parent)
    }
    override fun onBindViewHolder(holder: DeptViewHolder,
                                  position: Int) {
        val current = getItem(position)
        holder.bind(current.name)
    }
    class DeptViewHolder(itemView: View) : RecyclerView.
    ViewHolder(itemView) {
        private val wordItemView: TextView = itemView.
        findViewById(R.id.textView)
        fun bind(text: String?) {
            wordItemView.text = text
        }
        companion object {
            fun create(parent: ViewGroup): DeptViewHolder { val view: View = LayoutInflater.from(parent
                .context)
                .inflate(R.layout.recyclerview_item,
                    parent, false)
                return DeptViewHolder(view)
            }
        }
    }
    class DeptsComparator : DiffUtil.ItemCallback<Dept>() {
        override fun areItemsTheSame(oldItem: Dept, newItem
        : Dept): Boolean {

            return oldItem === newItem
        }
        override fun areContentsTheSame(oldItem: Dept,
                                        newItem: Dept): Boolean {
            return oldItem.name == newItem.name
        }
    }
}