package com.example.roomtest

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.sqlite.db.SupportSQLiteDatabase
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import kotlin.reflect.KParameter

@Database(entities = arrayOf(Dept::class), version = 1, exportSchema = false)
public abstract class DeptDatabase : RoomDatabase() {
    abstract fun deptDao(): DeptDAO

    companion object {
        @Volatile
        private var INSTANCE: DeptDatabase? = null
        fun getDatabase(
            context: Context,
            scope: CoroutineScope
        ): DeptDatabase {

            return INSTANCE ?: synchronized(this) {
                val instance = Room.databaseBuilder(
                    context.applicationContext,
                    DeptDatabase::class.java,
                    "dept_database"
                ).addCallback(DeptDatabaseCallback(scope)).build()
                INSTANCE = instance
                instance
            }
        }
    }

    private class DeptDatabaseCallback(private val scope:
                                       CoroutineScope
    ) : RoomDatabase.Callback() {
        override fun onCreate(db: SupportSQLiteDatabase) {
            super.onCreate(db)
            INSTANCE?.let { database ->
                scope.launch {
                    populateDatabase(database.deptDao())
                }
            }
        }

        suspend fun populateDatabase(deptDao: DeptDAO) {
            deptDao.deleteAll()
            var tab = arrayOf("MEA", "IG", "STE", "M&I", "Mat", "STIA")
            var dept: Dept
            for (name in tab) {
                dept = Dept(name)
                deptDao.insert(dept)
            }
        }
    }

}