package com.example.roomtest

import android.app.Activity
import android.content.Intent
import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Toast
import androidx.activity.viewModels
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.google.android.material.floatingactionbutton.FloatingActionButton
import kotlinx.coroutines.flow.count


class MainActivity : AppCompatActivity() {

    private val newDeptActivityRequestCode = 1

    private val deptViewModel: DeptViewModel by viewModels {
        DeptViewModelFactory(
            (application as DeptApplication).deptDao
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        val recyclerView = findViewById<RecyclerView>(R.id.deptslist)
        val adapter = DeptListAdapter()
        recyclerView.adapter = adapter
        recyclerView.layoutManager = LinearLayoutManager(this)

        deptViewModel.allDepts.observe(this) {
                depts -> depts.let { adapter.submitList(it) }
        }

        val add =
            findViewById<FloatingActionButton>(R.id.addButton)
        add.setOnClickListener {
            val intent = Intent(
                this@MainActivity, NewDept::class.java)
            startActivityForResult(
                intent, newDeptActivityRequestCode)
        }

        val dept = Dept("new")
        deptViewModel.insert(dept)


    }

    override fun onActivityResult(requestCode: Int,
                                  resultCode: Int, intentData: Intent?) {
        super.onActivityResult(
            requestCode, resultCode, intentData)
        if(requestCode == newDeptActivityRequestCode && resultCode == Activity.RESULT_OK) {
                intentData?.getStringExtra(NewDept.EXTRA_REPLY)?.let{ reply ->
                    val dept = Dept(reply)
                    deptViewModel.insert(dept)
                }
        }
        else {
            Toast.makeText(
                applicationContext,
                "chaîne vide, aucun ajout n'est fait",
                Toast.LENGTH_LONG
            ).show()
        }
    }
}