package com.example.roomtest

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import kotlinx.coroutines.flow.Flow

@Dao
interface DeptDAO {
    @Query("SELECT * FROM departements ORDER BY name ASC")
    fun getDeptNames(): Flow<List<Dept>>
    @Insert(onConflict = OnConflictStrategy.IGNORE)
    suspend fun insert(dept: Dept)
    @Query("DELETE FROM departements")
    suspend fun deleteAll()
}